<?php

class PeepSoAdminAddons extends PeepSoAjaxCallback
{

    public function check_license(PeepSoAjaxResponse $resp)
    {
        if (!PeepSo::is_admin()) {
            $resp->success(false);
            $resp->error(__('Insufficient permissions.', 'peepso-core'));
            return;
        }

        $input = new PeepSoInput();

        $peepso_bundle = [
            'free' => 64823085,
	        'community' => 114753103,
            'ultimate' => 18276205,
            'ultimate5' => 44808693,
            'monthly'   => 67105898,
            'ultimatemonthly'    => 45963636,
            'basic' => 30017488,
            'starter' => 30800413,
            'legacy'    => 2714533,
        ];

        $current_item_id = 0;
        $license = $input->value('license', '', FALSE);  // SQL Safe
        $license_changed = $input->value('license_changed', 0, [0,1]);
        $license_page_reference = $input->value('license_page_reference', '', FALSE);

        if (!empty($license)) {
            PeepSoConfigSettings::get_instance()->set_option('bundle_license', $license);
        }

        if(strlen($license)) {
            $current_item_id = PeepSo3_Helper_Addons::license_to_id($license, $license_changed);
        }

        $bundle_info = PeepSo3_Helper_Addons::get_addons();

        if(!is_array($bundle_info)) {
            return;
        }

        $new_products = $products = $classes = $can_install = [];

        // find products on bundle
        foreach ($bundle_info as $bundle) {
            if (strpos($bundle->name, 'Theme') !== FALSE) {
                $category = 'Theme';
                $product_name = strpos($bundle->name, 'Gecko')!==FALSE ? 'Gecko Theme' : 'Block Theme';
            } else if (strpos($bundle->name, 'Early Access') !== FALSE) {
                $category = $product_name = 'Early Access';
            } else if (strpos($bundle->name, ':')) {
                $name = explode(': ', $bundle->name);
                $category = $name[0];
                $product_name = $name[1];
            }

            if (isset($bundle->beta)) {
                $product_name .= ' (BETA)';
            }

            if (isset($bundle->class)) {
                $classes[$bundle->id] = $bundle->class;
            }

            $products[$category][$bundle->id] = $product_name;
            $product_descriptions[$bundle->id] = isset($bundle->desc) ? $bundle->desc : '';
            $product_bundles[$bundle->id] = $bundle->bundles;

            if (in_array($current_item_id, $bundle->bundles)) {
                $can_install[] = $bundle->id;
            }

            if(isset($bundle->new) && 0!=$bundle->new) {
                $new_products[] = $bundle->id;
            }
        }

        ksort($products);

        // move Gecko to top
        $lastvalue = end($products);
        $lastkey = key($products);

        $tmp = [$lastkey => $lastvalue];
        array_pop($products);

        $products = array_merge($tmp, $products);

        // move Early Access to bottom
        $products += array_splice($products, array_search('Early Access', array_keys($products)), 1);

        $html = '';

        if (!function_exists('get_plugins')) {
            require_once ABSPATH . 'wp-admin/includes/plugin.php';
        }

        // check PeepSo plugins
        $peepso_plugins = array_filter(get_plugins(), function ($var) {
            return ($var['Author'] == 'PeepSo');
        });

        // check Gecko theme
        $gecko_installed = FALSE;
        $block_theme_installed = FALSE;
        foreach (wp_get_themes() as $key => $value) {

            // @since 3.6.2.0 due to WordPress.org tag requirements, we have hidden  Gecko Parent in description
            $desc = (isset($value['Description'])) ? $value['Description'] : '';

            if(stristr($desc, "PeepSo Block Theme Parent")) {
                $block_theme_installed = TRUE;
            }

            if(stristr($desc,'Gecko Parent')) {
                $gecko_installed = TRUE;
            }

            // Legacy tag-based detection
            if(!$gecko_installed) {
                $tags = (isset($value['Tags']) && is_array($value['Tags'])) ? $value['Tags'] : [];
                $tags = array_map('strtolower', $tags);

                if (in_array('gecko parent', $tags)) {
                    $gecko_installed = TRUE;
                }
            }
        }

        if($license_changed) {
            // delete license display warning
            PeepSo3_Mayfly::del('peepso_has_displayed_license_warning');

            ob_start();

            $activate_products = apply_filters( 'peepso_license_config', array() );

            if ( count( $activate_products ) ) {

//                PeepSoCom_Connect::rate_limit_reset();
                PeepSoCom_Connect::reset_errors();

                foreach ($activate_products as $prod) {
                    $slug = $prod['plugin_slug'];
                    $id = $prod['plugin_edd'];

                    PeepSoConfigSettings::get_instance()->set_option('site_license_' . $slug, $license); // prevent cached license
                    PeepSo3_Mayfly::del('peepso_license_' . $slug);
                    PeepSoLicense::activate_license($slug, $id);
                }
            }
            if(class_exists('Gecko_Customizer')) {
                $options = get_option('gecko_options', []);
                $options = is_array($options) ? $options : [];
                $options['gecko_license'] = $license;
                update_option('gecko_options', $options);
            }

            $html .= ob_get_clean();
        }

        foreach ($products as $category_name => $categories) {
            $i = 0;
            if (is_array($categories) && count($categories) > 0) {
                foreach ($categories as $item_id => $item_name) {
                    $data = [
                        'class' => isset($classes[$item_id]) ? $classes[$item_id] : '',
                        'can_install' => $can_install,
                        'bundles' => $product_bundles[$item_id],
                        'category' => $i == 0 ? $category_name : '',
                        'item_id' => $item_id,
                        'item_name' => $item_name,
                        'item_description' => $product_descriptions[$item_id],
                        'peepso_plugins' => $peepso_plugins,
                        'gecko_installed' => $gecko_installed,
                        'block_theme_installed' => $block_theme_installed,
                        'is_new' => in_array($item_id, $new_products),
                        'license_changed' => $license_changed,
                        'license_page_reference' => $license_page_reference,
                    ];
                    $html .= PeepSoTemplate::exec_template('admin', 'addons_product', $data, true);
                    $i++;
                }
            }
        }

        // Set response
        $resp->set('addons', $html);

        if ($current_item_id) {
            $bundle = ucfirst(array_search($current_item_id, $peepso_bundle));
            if($bundle == 'Ultimate5') {
                $bundle_name = 'PeepSo Ultimate Bundle (5 Years)';
            } elseif($bundle == 'Ultimatemonthly') {
                $bundle_name = 'PeepSo Ultimate Bundle (Monthly)';
            } else {
                $bundle_name = 'PeepSo ' . $bundle . ' Bundle';
            }

            if ($bundle == 'Free') {
                PeepSo3_Mayfly::set('peepso_has_displayed_license_warning', 1, HOUR_IN_SECONDS);
            }

            $resp->set('bundle_name', $bundle_name);
        } else {
            PeepSo3_Mayfly::set('peepso_has_displayed_license_warning', 1, HOUR_IN_SECONDS);

            $resp->set('message', __('Invalid license key', 'peepso-core'));
        }

        $resp->success(true);
    }

    public function install(PeepSoAjaxResponse $resp)
    {
        require_once ABSPATH . 'wp-admin/includes/plugin.php';
        require_once ABSPATH . 'wp-includes/pluggable.php';
        require_once ABSPATH . 'wp-admin/includes/file.php';
        require_once ABSPATH . 'wp-admin/includes/misc.php';
        require_once ABSPATH . 'wp-admin/includes/class-wp-upgrader.php';

        $license = PeepSo3_Helper_Addons::get_license();
        if ($license) {
            $input = new PeepSoInput();
            $item_id = $input->value('item_id');

            $api_params = array(
                'edd_action' => 'get_version',
                'license'    => $license,
                'item_id'    => $item_id,
                'url'        => home_url(),
            );


            $pscc =  /** checked for NULL**/ (new PeepSoCom_Connect($api_params))->get();
            if (NULL!==$pscc && is_string($pscc) ) {

	            #7606 - replace www.peepso.com/edd-sl with secondary URL, if needed - this fixes updates on GoDaddy
	            $pscc = str_ireplace("www.peepso.com\/edd-sl", PeepSo::get_option_new('peepsocom_connect_url_base')."\/edd-sl", $pscc);
	            $peepso_dir = PeepSo::get_option('site_peepso_dir', WP_CONTENT_DIR . DIRECTORY_SEPARATOR . 'peepso', TRUE);
	            $file = 'peepsocom_connect';
	            error_log ( "\n\n\nPSCC FIX FOR GODADDY - INSTALLER \n\n\n".print_r($pscc, true), 3, $peepso_dir.'/'.$file.'.txt');
                $request = json_decode($pscc);

                if (isset($request->download_link)) {
                    // get slug
                    $bundle_info = PeepSo3_Mayfly::get('bundle_info');
                    if(!is_array($bundle_info)) {
                        return;
                    }
                    $item_info = array_values(array_filter($bundle_info, function ($var) use ($item_id) {
                        return ($var->id == $item_id);
                    }));

                    sort($item_info);
                    $slug = $item_info[0]->slug;

                    // activate license
                    PeepSoConfigSettings::get_instance()->set_option('site_license_' . $slug, $license); // prevent cached license
                    PeepSo3_Mayfly::del('peepso_license_' . $slug);
                    PeepSoLicense::activate_license($slug, $item_id);

                    if($item_id==115220226){
                        $options = get_option('block_options', []);
                        $options = is_array($options) ? $options : [];
                        $options['block_license'] = $license;
                        update_option('block_options', $options);
                        $upgrader = new Theme_Upgrader(new WP_Ajax_Upgrader_Skin(['title' => $request->name]));
                    }
                    elseif ($item_id == 7354103) { // Gecko
                        $options = get_option('gecko_options', []);
                        $options = is_array($options) ? $options : [];
                        $options['gecko_license'] = $license;
                        update_option('gecko_options', $options);
                        $upgrader = new Theme_Upgrader(new WP_Ajax_Upgrader_Skin(['title' => $request->name]));
                    } else {
                        $upgrader = new Plugin_Upgrader(new WP_Ajax_Upgrader_Skin(['title' => $request->name]));
                    }
                    $result = $upgrader->install($request->download_link, [
                        'overwrite_package' => TRUE
                    ]);

                    $resp->set('result', $result);
                } else if (isset($request->msg)) {
                    $resp->set('message', $request->msg);
                }
            }
        } else {
            PeepSo3_Mayfly::set('peepso_has_displayed_license_warning', 1, HOUR_IN_SECONDS);
            $resp->set('message', __('Invalid license key', 'peepso-core'));
        }

        $resp->success(true);
    }

    public function hide_tutorial(PeepSoAjaxResponse $resp) {
        update_user_option(get_current_user_id(), 'peepso_user_installer_tutorial', 1);
        $resp->success(true);
    }
}
