<?php

class PeepSo3_Site_Health {

    private static $instances;

    public static function get_instance() {
        if(!is_admin()) {
            return;
        }

        $class = get_called_class();

        if (!isset(self::$instances[$class])) {
            $child = new $class();
            self::$instances[$class] = new $class($child);
            unset($child);
        }

        return self::$instances[$class];
    }

    public $status = 'good';
    public $color = 'green';

    public $label = '';
    public $description = '';

    protected function __construct($that = NULL) {
        if($that) {
            add_filter('site_status_tests', function($tests) use($that){
                $tests['direct'][get_class($that)] = [
                    'test' => [&$that,'test']
                ];

                return $tests;
            });
        }
    }


    protected function result() {

    	$br = '';
    	if(strlen($this->description)) {
    		$br ='<br/><br/>';
	    }
	    $this->description = $this->description
            . $br.'<span style="opacity:0.75">'

	                         . sprintf( esc_attr__('This message was generated by %s.','peepso-core'),'<a href="https://www.PeepSo.com" target="_blank">PeepSo</a>')
	                         . '</span>';

        $result = [
            'label' => $this->label,
            'status' => $this->status,
            'description' => $this->description,
            'actions' => '',
            'test' => get_class($this),
        ];

        if($this->status=='good') {
            $result['label'] = '(OK) ' . $result['label'];
        } else {
            $this->color = 'orange';
            if ('critical' == $this->status) {
                $this->color = 'red';
            }
        }

        $result['badge'] = ['label' => 'PeepSo', 'color' => $this->color];

        return $result;
    }

    protected function success() {


        return $result;
    }

}